#include <bits/stdc++.h>
using namespace std;

typedef pair <int, int> pii;

const int MAXN = 5e5 + 5;

struct Edge {
  int from, to, idx;
};

int N, K;
int dp[MAXN];
vector <int> nodes;
vector <int> ch[MAXN], undir[MAXN];
vector <pii> adj[MAXN], dir[MAXN];
bool act[MAXN], bio[MAXN];
int in[MAXN], out[MAXN];

void add_node(int u) {
  if (act[u])
    return;
  nodes.push_back(u);
  act[u] = true;
}

void remove_node(int u) {
  in[u] = out[u] = 0;
  act[u] = bio[u] = false;
  undir[u].clear();
}

void update_degree(int u, int v) {
  in[v]++;
  out[u]++;
  add_node(u);
  add_node(v);
}

void add_edge(int u, int v, int w) {
  undir[u].push_back(v);
  undir[v].push_back(u);
  update_degree(u, v);
}

void dfs_connected(int x) {
  bio[x] = true;
  for (auto it : undir[x])
    if (!bio[it])
      dfs_connected(it);
}

void euler_walk(int curr, int edge, int node) {
  while (!dir[curr].empty()) {
    pii nxt = dir[curr].back();
    dir[curr].pop_back();
    euler_walk(nxt.first, nxt.second, node);
  }
  if (edge)
    ch[node].push_back(edge);
}

void process_children(int node, int st, int en, vector <Edge> edges) {
  if (edges.empty())
    return;
  for (auto it : edges) 
    add_edge(it.from, it.to, it.idx);
  dfs_connected(en);
  update_degree(en, st);
  for (; !nodes.empty(); nodes.pop_back()) {
    if (in[nodes.back()] != out[nodes.back()] || !bio[nodes.back()]) {
      puts("NE");
      exit(0);
    }
    remove_node(nodes.back());
  }
  for (auto it : edges)
    dir[it.from].push_back({it.to, it.idx});
  euler_walk(st, 0, node);
  reverse(ch[node].begin(), ch[node].end());
}

void load() {
  scanf("%d%d", &N, &K);
  for (int i = 1; i < N; i++) {
    int u, v, w;
    scanf("%d%d%d", &u, &v, &w);
    adj[u].push_back({v, w - 1});
    adj[v].push_back({u, w - 1});
  }
}

int dfs_solve(int x, int p, int e) {
  int sub = 1;
  vector <Edge> edges;
  auto add = [](int a, int b) -> int {
    a += b;
    return a < K ? a : a - K;
  };
  for (auto it : adj[x])
    if (it.first != p) {
      int sz = dfs_solve(it.first, x, it.second);
      edges.push_back({it.second, add(it.second, sz), it.first});
      sub = add(sub, sz);
    }
  process_children(x, add(e, 1), add(e, sub), edges);
  return sub;
}

void construct(int x) {
  printf("%d ", x);
  for (auto it : ch[x]) {
    construct(it);
    printf("%d ", x);
  }
}

void solve() {
  dfs_solve(1, 0, K - 1);
  puts("DA");
  construct(1);
  puts("");
}

int main() {
  load();
  solve();
  return 0;
}
